package com.wecloud.im.controller;

import com.wecloud.im.param.ImMsgReadStatusUpdate;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.service.ImInboxService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 消息收件箱表 控制器
 *
 * @author wei
 * @since 2021-05-06
 */
@Slf4j
@RestController
@RequestMapping("/imInbox")
@Api(value = "消息收件箱表API", tags = {"消息收件箱表"})
public class ImInboxController extends BaseController {

    @Autowired
    private ImInboxService imInboxService;

    /**
     * 消息修改为已接收状态
     */
    @PostMapping("/msgReceivedUpdate")
    @ApiOperation(value = "消息修改为已接收状态")
    public ApiResult<Boolean> updateImMsgReceived(@RequestBody @Validated ImMsgReceivedStatusUpdate imMsgReceivedUpdate) throws Exception {
        return imInboxService.updateImMsgReceived(imMsgReceivedUpdate);
    }

    /**
     * 消息修改为已读状态
     */
    @PostMapping("/msgReadUpdate")
    @ApiOperation(value = "消息修改为已读状态")
    public ApiResult<Boolean> updateInMsgReadUpdate(@RequestBody ImMsgReadStatusUpdate imMsgReadStatusUpdate) throws Exception {
        return imInboxService.updateImMsgRead(imMsgReadStatusUpdate);
    }

//
//    /**
//     * 添加消息收件箱表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加消息收件箱表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加消息收件箱表")
//    public ApiResult<Boolean> addImInbox(@Validated(Add.class) @RequestBody ImInbox imInbox) throws Exception {
//        boolean flag = imInboxService.saveImInbox(imInbox);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改消息收件箱表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改消息收件箱表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改消息收件箱表")
//    public ApiResult<Boolean> updateImInbox(@Validated(Update.class) @RequestBody ImInbox imInbox) throws Exception {
//        boolean flag = imInboxService.updateImInbox(imInbox);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除消息收件箱表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除消息收件箱表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除消息收件箱表")
//    public ApiResult<Boolean> deleteImInbox(@PathVariable("id") Long id) throws Exception {
//        boolean flag = imInboxService.deleteImInbox(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取消息收件箱表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "消息收件箱表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "消息收件箱表详情")
//    public ApiResult<ImInboxQueryVo> getImInbox(@PathVariable("id") Long id) throws Exception {
//        ImInboxQueryVo imInboxQueryVo = imInboxService.getImInboxById(id);
//        return ApiResult.ok(imInboxQueryVo);
//    }
//
//    /**
//     * 消息收件箱表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "消息收件箱表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "消息收件箱表分页列表")
//    public ApiResult<Paging<ImInboxQueryVo>> getImInboxPageList(@Validated @RequestBody ImInboxPageParam imInboxPageParam) throws Exception {
//        Paging<ImInboxQueryVo> paging = imInboxService.getImInboxPageList(imInboxPageParam);
//        return ApiResult.ok(paging);
//    }

}

