package com.wecloud.im.sdk.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.model.WebServiceRequest;

/**
 * HTTP request message builder.
 * @Author luozh
 * @Date 2022年04月13日 15:49
 * @Version 1.0
 */
public class WecloudRequestMessageBuilder {

    private String endpoint;

    private HttpMethod method = HttpMethod.GET;

    private Map<String, String> headers = new HashMap<String, String>();

    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    private WebServiceRequest originalRequest;

    public String getEndpoint() {
        return endpoint;
    }

    public WecloudRequestMessageBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpMethod getMethod() {
        return method;
    }

    public WecloudRequestMessageBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(headers);
    }

    public WecloudRequestMessageBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public WecloudRequestMessageBuilder addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public WecloudRequestMessageBuilder addHeader(String key, String value) {
        headers.put(key, value);
        return this;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(parameters);
    }

    public WecloudRequestMessageBuilder setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public WecloudRequestMessageBuilder addParameter(String key, String value) {
        parameters.put(key, value);
        return this;
    }

    public WebServiceRequest getOriginalRequest() {
        return originalRequest;
    }

    public WecloudRequestMessageBuilder setOriginalRequest(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public RequestMessage build() {
        Map<String, String> sentHeaders = new HashMap<String, String>(this.headers);
        Map<String, String> sentParameters = new LinkedHashMap<String, String>(this.parameters);
        RequestMessage request = new RequestMessage(this.originalRequest);
        request.setEndpoint(endpoint);
        request.setHeaders(sentHeaders);
        request.setParameters(sentParameters);
        request.setMethod(this.method);
        return request;
    }


}
