package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.param.ImInboxPageParam;
import com.wecloud.im.param.ImInboxQueryVo;
import com.wecloud.im.vo.ConversationCountVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.List;

/**
 * 消息收件箱表 Mapper 接口
 *
 * @author wei
 * @since 2021-05-06
 */
@Repository
public interface ImInboxMapper extends BaseMapper<ImInbox> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImInboxQueryVo getImInboxById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imInboxPageParam
     * @return
     */
    IPage<ImInboxQueryVo> getImInboxPageList(@Param("page") Page page, @Param("param") ImInboxPageParam imInboxPageParam);


    Long updateImMsgReceivedByIds(@Param("clientId") Long clientId, @Param("msgIds") List<Long> msgIds);

    Long updateImMsgReadByIds(@Param("clientId") Long clientId, @Param("msgIds") List<Long> msgIds);

    /**
     * 统计未读消息数量
     *
     * @param fkClientId
     * @return
     */
    List<ConversationCountVo> countMyNotRead(@Param("fkClientId") Long fkClientId);

    /**
     * 统计被@数量
     * @param fkClientId
     * @param clientId
     * @return
     */
    List<ConversationCountVo> countBeAt(@Param("fkClientId") Long fkClientId, @Param("clientId") String clientId);
}
