package com.wecloud.im.friend.param;

import com.wecloud.im.friend.enums.AddFriendSceneEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description 申请好友入参
 * @Author lixiaozhong
 * @Date 2022/1/13 4:24 下午
 */
@Data
public class ImFriendApplyParam extends ImFriendBaseParam {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会话id，群成员添加好友时传参")
    private Long conversationId;

    @ApiModelProperty("备注好友名称")
    private String friendName;

    @ApiModelProperty("请求备注")
    private String requestRemark;

    @ApiModelProperty("是否需要验证")
    private Boolean needVerify = true;

    @ApiModelProperty("加好友入口场景")
    private AddFriendSceneEnum addFriendScene;
}
