/*
 * Decompiled with CFR 0.152.
 */
package com.wecloud.classencrypt.util;

import com.wecloud.classencrypt.util.IoUtils;
import java.io.File;

public class HtmlUtils {
    public static void main(String[] args) throws Exception {
        String txt = IoUtils.readTxtFile(new File("/Users/roseboy/work-yiyon/\u6613\u7528\u6846\u67b6/yiyon-framework/jeee-importer/src/main/resources/templates/importer-upload-form-pro.ftl"));
        long t1 = System.currentTimeMillis();
        txt = HtmlUtils.removeComments(txt);
        txt = HtmlUtils.removeBlank(txt);
        long t2 = System.currentTimeMillis();
        System.out.println(txt);
    }

    public static String removeBlank(String code) {
        StringBuilder result = new StringBuilder();
        int quot = 0;
        int quots = 0;
        boolean inScript = false;
        boolean inStyle = false;
        boolean inTextArea = false;
        char[] chars = code.replace("\r\n", "\n").toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (inStyle) {
                if (HtmlUtils.isElementEnd(i, chars, "</style>")) {
                    inStyle = false;
                }
                if (chars[i] == ' ' || chars[i] == '\n') continue;
                result.append(chars[i]);
                continue;
            }
            if (inScript) {
                if (HtmlUtils.isElementEnd(i, chars, "</script>")) {
                    inScript = false;
                }
                if (chars[i] == '\n') continue;
                result.append(chars[i]);
                continue;
            }
            if (inTextArea) {
                if (HtmlUtils.isElementEnd(i, chars, "</textarea>")) {
                    inTextArea = false;
                }
                result.append(chars[i]);
                continue;
            }
            if (chars[i] == '\"' && chars[i - 1] != '\\' && quot % 2 == 0) {
                ++quots;
                result.append(chars[i]);
                continue;
            }
            if (chars[i] == '\'' && chars[i - 1] != '\\' && quots % 2 == 0) {
                ++quot;
                result.append(chars[i]);
                continue;
            }
            if (quot % 2 == 0 && quots % 2 == 0) {
                if (HtmlUtils.isElementBegin(i, chars, "<script>")) {
                    i = HtmlUtils.append(i, chars, result, '>');
                    inScript = true;
                    continue;
                }
                if (HtmlUtils.isElementBegin(i, chars, "<style>")) {
                    i = HtmlUtils.append(i, chars, result, '>');
                    inStyle = true;
                    continue;
                }
                if (HtmlUtils.isElementBegin(i, chars, "<textarea>")) {
                    i = HtmlUtils.append(i, chars, result, '>');
                    inTextArea = true;
                    continue;
                }
                if (chars[i] == '<') {
                    i = HtmlUtils.append(i, chars, result, '>');
                    continue;
                }
                result.append(chars[i]);
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    public static String removeComments(String code) {
        StringBuilder result = new StringBuilder();
        int quot = 0;
        int quots = 0;
        boolean jumpToNextLine = false;
        boolean jumpToComment1 = false;
        boolean jumpToComment2 = false;
        char[] chars = code.replace("\r\n", "\n").toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (jumpToNextLine) {
                if (chars[i] != '\n') continue;
                jumpToNextLine = false;
                result.append(chars[i]);
                continue;
            }
            if (jumpToComment1) {
                if (!HtmlUtils.isElementEnd(i, chars, "*/")) continue;
                jumpToComment1 = false;
                continue;
            }
            if (jumpToComment2) {
                if (!HtmlUtils.isElementEnd(i, chars, "-->")) continue;
                jumpToComment2 = false;
                continue;
            }
            if (chars[i] == '\"' && chars[i - 1] != '\\' && quot % 2 == 0) {
                ++quots;
                result.append(chars[i]);
                continue;
            }
            if (chars[i] == '\'' && chars[i - 1] != '\\' && quots % 2 == 0) {
                ++quot;
                result.append(chars[i]);
                continue;
            }
            if (quot % 2 == 0 && quots % 2 == 0) {
                if (HtmlUtils.isElementBegin(i, chars, "// ")) {
                    jumpToNextLine = true;
                    continue;
                }
                if (HtmlUtils.isElementBegin(i, chars, "/* ")) {
                    jumpToComment1 = true;
                    continue;
                }
                if (HtmlUtils.isElementBegin(i, chars, "<!-- ")) {
                    jumpToComment2 = true;
                    continue;
                }
                result.append(chars[i]);
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    private static boolean isElementBegin(int index, char[] chars, String element) {
        element = element.toLowerCase();
        for (int i = 0; i < element.length() - 1; ++i) {
            if (Character.toLowerCase(chars[index + i]) == element.charAt(i)) continue;
            return false;
        }
        return element.charAt(element.length() - 1) == ' ' || chars[index + element.length() - 1] == ' ' || chars[index + element.length() - 1] == element.charAt(element.length() - 1);
    }

    private static boolean isElementEnd(int index, char[] chars, String element) {
        element = element.toLowerCase();
        for (int i = index; i > index - element.length(); --i) {
            if (Character.toLowerCase(chars[i]) == element.charAt(element.length() - index + i - 1)) continue;
            return false;
        }
        return true;
    }

    private static int append(int i, char[] chars, StringBuilder result, char endChar) {
        while (chars[i] != endChar) {
            int n = chars[i] = chars[i] == '\n' ? 32 : chars[i];
            if (chars[i] == ' ' && chars[i - 1] == ' ') {
                ++i;
                continue;
            }
            result.append(chars[i++]);
        }
        result.append(chars[i]);
        return i;
    }

    public static String removeBlankLine(String code) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        for (String line : lines = code.split("\n")) {
            if ((line = line.trim()).length() == 0) continue;
            result.append(line).append("\n");
        }
        return result.toString();
    }
}

