package com.wecloud.im.service;

import com.wecloud.im.entity.ImClient;
import com.wecloud.im.param.ImClientPageParam;
import com.wecloud.im.param.ImClientQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 终端表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImClientService extends BaseService<ImClient> {

    /**
     * 保存
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean saveImClient(ImClient imClient) throws Exception;

    /**
     * 修改
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean updateImClient(ImClient imClient) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImClient(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImClientQueryVo getImClientById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imClientPageParam
     * @return
     * @throws Exception
     */
    Paging<ImClientQueryVo> getImClientPageList(ImClientPageParam imClientPageParam) throws Exception;


    ImClient getClient();

}
