package com.wecloud.im.tillo.app_ws.strategy.concrete;

import cn.hutool.core.lang.Snowflake;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.service.ImMessageService;
import com.wecloud.im.tillo.app_ws.annotation.ReceiveTypeAnnotation;
import com.wecloud.im.tillo.app_ws.enums.WsRequestCmdEnum;
import com.wecloud.im.tillo.app_ws.model.request.ReceiveModel;
import com.wecloud.im.tillo.app_ws.service.MangerChannelService;
import com.wecloud.im.tillo.app_ws.strategy.AbstractReceiveStrategy;
import io.netty.channel.ChannelHandlerContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @Description 处理app单聊消息
 */
@ReceiveTypeAnnotation(type = WsRequestCmdEnum.DATA)
@Service
@Slf4j
public class SingleConcreteReceiveStrategy extends AbstractReceiveStrategy {

    @Autowired
    private ImMessageService imMessageService;

    @Autowired
    private ImInboxService imInboxService;

    @Autowired
    private ImApplicationService imApplicationService;

    @Override
    public void process(ReceiveModel requestModel, String language, ChannelHandlerContext ctx, String data) {

        String appKey = ctx.channel().attr(MangerChannelService.APP_KEY).get();
        String clientId = ctx.channel().attr(MangerChannelService.CLIENT_ID).get();

        ImApplication imApplication = imApplicationService.getOne(new QueryWrapper<ImApplication>().lambda()
                .eq(ImApplication::getAppKey, appKey));

        JsonMapper jsonMapper = new JsonMapper();
        String content = null;
        Long toConversation = Long.valueOf(requestModel.getData().get("toConversation").toString());
        long messageId = new Snowflake(1L, 1L).nextId();
        long imInboxId = new Snowflake(1L, 1L).nextId();
        try {
            content = jsonMapper.writeValueAsString(requestModel.getData());
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }

        //  保存离线消息
        ImMessage imMessage = new ImMessage();
        imMessage.setId(messageId);
        imMessage.setCreateTime(new Date());
//        imMessage.setWithdrawTime(new Date());
//        imMessage.setUpdateDate(new Date());
        imMessage.setFkAppid(imApplication.getId());
        imMessage.setSender(0L);
        imMessage.setContent(content);
        imMessage.setWithdraw(false);
        imMessage.setEvent(false);
        imMessage.setSystem(false);
//        imMessage.setAt("");
        imMessage.setSendStatus(0);
        imMessage.setFkConversationId(toConversation);
        imMessageService.save(imMessage);

        //  向接收方推送
        //        ChannelFuture channelFuture = ctx.writeAndFlush(new TextWebSocketFrame(data));
        ImInbox imInbox = new ImInbox();
        imInbox.setId(imInboxId);
        imInbox.setCreateTime(new Date());
//        imInbox.setUpdateTime(new Date());
//        imInbox.setReceiverDate(new Date());
        imInbox.setFkAppid(123L);
        imInbox.setReceiver(12L);
        imInbox.setFkMsgId(messageId);
        imInbox.setReadMsg(0);
        imInbox.setFkConversationId(toConversation);
        imInboxService.save(imInbox);

    }
}
