package com.wecloud.im.tillo.app_ws.service;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Description 管理netty用户channel对象
 * @Author hewei hwei1233@163.com
 * @Date 2019-08-01
 */
public interface MangerChannelService {

    /**
     * channel对象
     * 用户id为key
     * context为值
     */
    Map<String, NioSocketChannel> CHANNEL_MAP = new ConcurrentHashMap<>();

    /**
     * CLIENT_ID
     */
    AttributeKey<String> CLIENT_ID = AttributeKey.valueOf("CLIENTID");

    AttributeKey<String> APP_KEY = AttributeKey.valueOf("APPKEY");

    /**
     * LANGUAGE
     */
    AttributeKey<String> LANGUAGE = AttributeKey.valueOf("language");

    /**
     * APP_VERSION
     */
    AttributeKey<String> APP_VERSION = AttributeKey.valueOf("appVersion");
    AttributeKey<String> TOKEN = AttributeKey.valueOf("TOKEN");
    AttributeKey<String> DEVICEID = AttributeKey.valueOf("DEVICEID");
    AttributeKey<String> PLATFORM = AttributeKey.valueOf("PLATFORM");

    /**
     * 根据userID获取channel
     * @param userId
     * @return
     */
    NioSocketChannel get(String userId);

    /**
     * userID绑定channel
     * @param userId
     * @param channel
     */
    void put(String userId, NioSocketChannel channel);

    /**
     * 移除channel
     * @param channelHandlerContext
     */
    void remove(ChannelHandlerContext channelHandlerContext);

    /**
     * 根据channel返回userId
     *
     * @param channelHandlerContext
     * @return
     */
    Long getUserIdByChannel(ChannelHandlerContext channelHandlerContext);

    /**
     * 下发数据
     *
     * @param msg
     * @param userId
     * @return
     */
//    boolean writeData(String msg, Long userId);


    /**
     * 下发数据
     *
     * @param msg
     * @return
     */
    boolean writeData(String msg, String toAppKey,String toClientId);

//    /**
//     * rpc异步下发数据
//     *
//     * @param msg
//     * @param userId
//     * @return
//     */
//    boolean rpcWriteData(String msg, Long userId);
//
//    /**
//     * rpc-异步下发踢人数据及关闭旧通道
//     *
//     * @param msg
//     * @param userId
//     * @return
//     */
//    boolean rpcKickWriteData(String msg, Long userId);
//
//    /**
//     * rpc-异步关闭旧通道
//     *
//     * @param userId
//     * @return
//     */
//    boolean rpcCloseOldChannel(Long userId);
//
//    Boolean isOnLocal(Long userId);

}
