package io.geekidea.springbootplus.test;

import cn.hutool.core.lang.Snowflake;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.tillo.app_ws.utils.RSAGenerator;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.Date;

/**
 * 生成测试appkey与appSecret对,并存入数据库
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class AppKeyTest {

    public static void main(String[] args) {
        String appKey = RSAGenerator.getAppKey();  //定义变量接收
        String appSecret = RSAGenerator.getAppSecret(appKey);

        int i = 1;
    }


    @Autowired
    private ImApplicationService imApplicationService;

    @Test
    public void add() {
        for (int i = 0; i < 10000; i++) {
            addDb(i);

        }
    }

    private void addDb( int i) {
        String appKey = RSAGenerator.getAppKey();  //定义变量接收
        String appSecret = RSAGenerator.getAppSecret(appKey);

        ImApplication imApplication = new ImApplication();
        imApplication.setCreateTime(new Date());
        imApplication.setUpdateTime(new Date());
        imApplication.setId(new Snowflake(1L,1L).nextId());
        imApplication.setAppKey(appKey);
        imApplication.setAppSecret(appSecret);
        imApplication.setAppName("test"+i);

        imApplicationService.save(imApplication);
    }


}
