package com.wecloud.im.sdk.sample;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import cn.hutool.core.date.DateUtil;

import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.common.auth.HmacSHA256Signature;
import com.wecloud.im.sdk.internal.ImHeaders;
import com.wecloud.im.sdk.internal.SignUtils;
import com.wecloud.im.sdk.internal.WecloudRequestMessageBuilder;

public class SignTest {

    public static void main(String[] args) {

        String date = DateUtil.formatHttpDate(new Date());
        // 资源地址
        String resourcePath = "/api/imClient/registerClient";
        // 请求头
        Map<String, String> headers = new HashMap<>();
        headers.put(ImHeaders.DATE, date);
        headers.put(ImHeaders.CONTENT_TYPE, "application/json; charset=utf-8");
        // 请求参数
        Map<String, String> param = new HashMap<>();
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint("/api/imClient/registerClient")
                .setMethod(HttpMethod.POST).setParameters(param).addHeaders(headers)
                .setOriginalRequest(null).build();

        String canonicalString = SignUtils.buildCanonicalString("POST", resourcePath, request);
        String signature = new HmacSHA256Signature().computeSignature("287d04ds8099fb7de871e9dda845fa8b6b2302faf2ab3737", canonicalString);
        String authorization = SignUtils.composeRequestAuthorization("QizKVHcILRWp6Fd3", signature);
        System.out.println("canonicalString: " + canonicalString);
        System.out.println("signature: " + signature);
        System.out.println("Authorization header: " + authorization);

    }
}
