//package com.wecloud.im.ws.strategy;
//
//import com.wecloud.im.ws.annotation.ImCmdType;
//import com.wecloud.im.ws.enums.WsRequestCmdEnum;
//import com.wecloud.im.ws.utils.ClassScanner;
//import com.wecloud.im.ws.utils.SpringBeanUtils;
//import org.springframework.beans.factory.InitializingBean;
//import org.springframework.boot.context.event.ApplicationStartedEvent;
//import org.springframework.context.event.EventListener;
//import org.springframework.stereotype.Component;
//import org.springframework.util.CollectionUtils;
//
//import javax.annotation.PostConstruct;
//import java.util.HashMap;
//import java.util.Map;
//import java.util.Set;
//
///**
// * @Description 策略模式 上下文
// * 维护指令码与策略实现的对应
// * @Author hewei hwei1233@163.com
// */
//@Component
//public class ImCmdStrategyFactory {
//
//    private final Map<WsRequestCmdEnum, AbstractImCmdStrategy> strategyMap = new HashMap<>();
//
//    public AbstractImCmdStrategy getStrategy(WsRequestCmdEnum wsRequestPathEnum) {
//
//        if (wsRequestPathEnum == null) {
//            throw new IllegalArgumentException("not fond enum");
//        }
//
//        if (CollectionUtils.isEmpty(strategyMap)) {
//            throw new IllegalArgumentException("strategy map is empty,please check you strategy package path");
//        }
//
//        return strategyMap.get(wsRequestPathEnum);
//    }
//
//    @EventListener(ApplicationStartedEvent.class)
//    private void init() {
//
//        // 扫码ReceiveTypeAnnotation注解的类
//        Set<Class<?>> classSet = ClassScanner.scan(ImCmdStrategyFactory.class.getPackage().getName(), ImCmdType.class);
//
//        classSet.forEach(clazz -> {
//            // 获取注解中的类型值，与枚举类一一对应
//            WsRequestCmdEnum type = clazz.getAnnotation(ImCmdType.class).type();
//            strategyMap.put(type, (AbstractImCmdStrategy)SpringBeanUtils.getBean(clazz));
//        });
//    }
//}
