package com.wecloud.im.sdk.sample;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;

import com.alibaba.fastjson.JSONObject;
import com.wecloud.im.sdk.WecloudIm;
import com.wecloud.im.sdk.WecloudImClientBuilder;
import com.wecloud.im.sdk.model.GroupChatMessage;
import com.wecloud.im.sdk.model.GroupChatStatusMessage;

/**
 * 发布群消息
 * @Author luozh
 * @Date 2022年05月06日 01:37:29
 * @Version 1.0
 */
public class PublishGroupChatMessageSample {

    public static void main(String[] args) {
        WecloudIm im = new WecloudImClientBuilder().build("http://139.159.136.86:8082",
                "QizKVHcILRWp6Td2",
                "287d04828099fb7de871e9dda845fa8b6b2302faf2ab3737");

        String senderId = "1519984635566845952";
        String toGroupIds = "1519985463165931520";
        String messageType = "-1";

        Map<String, Object> msg = new HashMap<>();
        msg.put("toConversation", "1519985463165931520");
        msg.put("type", -1);
        msg.put("text", "这是测试消息: " + DateUtil.formatDateTime(new Date()));

        boolean silent = true;
        GroupChatMessage groupChatMessage = new GroupChatMessage();
        groupChatMessage.setFromUserId(senderId);
        groupChatMessage.setToGroupIds(toGroupIds);
        groupChatMessage.setMessageType(messageType);
        groupChatMessage.setContent(JSONUtil.toJsonStr(msg));
        groupChatMessage.setPushContent("");
        groupChatMessage.setIncludeSender(false);
        groupChatMessage.setPersisted(true);
        groupChatMessage.setMentioned(false);
        groupChatMessage.setSilent(silent);
//        groupChatMessage.setPushExt(new PushExtParam());

        String s = " {\"content\":\"{\\\"amount\\\":1.000,\\\"blessingWords\\\":\\\"恭喜发财，大吉大利\\\"," +
                "\\\"id\\\":1522526485813088256,\\\"liveStatus\\\":1,\\\"number\\\":1,\\\"payMode\\\":1,\\\"payStatus\\\":2,\\\"payTime\\\":1651833576000,\\\"redEnvelopeType\\\":2,\\\"remainingAmount\\\":0.000,\\\"remainingPacket\\\":0,\\\"sponsorAccountCode\\\":\\\"1517329604459835392\\\",\\\"targetType\\\":2}\",\"fromUserId\":\"1517329604459835392\",\"includeBlacklist\":false,\"includeSender\":true,\"messageType\":\"201\",\"toGroupIds\":\"1519985463165931520\"}";

        GroupChatStatusMessage groupChatMessage1 = JSONObject.parseObject(s, GroupChatStatusMessage.class);

        Boolean result = im.publishGroupChatStatusMessage(groupChatMessage1);
    }


}
