package com.jumeirah.api.app.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jumeirah.common.entity.SysNotice;
import com.jumeirah.common.entity.SysNoticeRead;
import com.jumeirah.common.param.SysNoticeQueryVo;
import com.jumeirah.common.service.SysNoticeReadService;
import com.jumeirah.common.service.SysNoticeService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 系统通知表 控制器
 *
 * @author xxx
 * @since 2020-11-06
 */
@Slf4j
@RestController
@RequestMapping("/app/sysNotice")
@Api(value = "系统通知表API", tags = {"系统通知表"})
public class SysNoticeController extends BaseController {

    @Autowired
    private SysNoticeService sysNoticeService;

    @Autowired
    private SysNoticeReadService sysNoticeReadService;

    @PostMapping("/getList")
    @OperationLog(name = "系统通知表列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "系统通知表列表")
    public ApiResult<List<SysNoticeQueryVo>> list() throws Exception {
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        List<SysNotice> list = sysNoticeService.list();

        List<SysNoticeQueryVo> sysNoticeQueryVoList = new ArrayList<>();
        for (SysNotice sysNotice : list) {

            SysNoticeQueryVo sysNoticeQueryVo = new SysNoticeQueryVo();
            sysNoticeQueryVo.setId(sysNotice.getId());
            sysNoticeQueryVo.setTheme(sysNotice.getTheme());
            sysNoticeQueryVo.setMsgInfo(sysNotice.getContent());
            sysNoticeQueryVo.setSendTime(sysNotice.getCreateTime());
        }

        // 修改为已读
        SysNoticeRead sysNoticeRead = sysNoticeReadService.getOne(new QueryWrapper<SysNoticeRead>().lambda()
                .eq(SysNoticeRead::getUserId, jwtToken.getUserId()));
        if (sysNoticeRead != null) {
            sysNoticeRead.setReadStatus(1);
            sysNoticeReadService.updateById(sysNoticeRead);
        }

        return ApiResult.ok(sysNoticeQueryVoList);
    }
//
//    /**
//     * 添加系统通知表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加系统通知表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加系统通知表")
//    public ApiResult<Boolean> addSysNotice(@Validated(Add.class) @RequestBody SysNotice sysNotice) throws Exception {
//        boolean flag = sysNoticeService.saveSysNotice(sysNotice);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改系统通知表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改系统通知表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改系统通知表")
//    public ApiResult<Boolean> updateSysNotice(@Validated(Update.class) @RequestBody SysNotice sysNotice) throws Exception {
//        boolean flag = sysNoticeService.updateSysNotice(sysNotice);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除系统通知表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除系统通知表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除系统通知表")
//    public ApiResult<Boolean> deleteSysNotice(@PathVariable("id") Long id) throws Exception {
//        boolean flag = sysNoticeService.deleteSysNotice(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取系统通知表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "系统通知表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "系统通知表详情")
//    public ApiResult<SysNoticeQueryVo> getSysNotice(@PathVariable("id") Long id) throws Exception {
//        SysNoticeQueryVo sysNoticeQueryVo = sysNoticeService.getSysNoticeById(id);
//        return ApiResult.ok(sysNoticeQueryVo);
//    }

    /**
     * 系统通知表分页列表
     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "系统通知表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "系统通知表分页列表")
//    public ApiResult<Paging<SysNoticeQueryVo>> getSysNoticePageList(@Validated @RequestBody SysNoticePageParam sysNoticePageParam) throws Exception {
//        Paging<SysNoticeQueryVo> paging = sysNoticeService.getSysNoticePageList(sysNoticePageParam);
//        return ApiResult.ok(paging);
//    }

}

