package com.wecloud.im.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author nanqianhao
 * @date 2022/6/16
 * @apiNote
 */
@Data
@ApiModel(value = "未接音视频记录返回对象")
public class MissedRtcRecordVO implements Serializable {

    private static final long serialVersionUID = 5095229246261665876L;

    @ApiModelProperty("频道id")
    private Long channelId;

    @ApiModelProperty("发起方clientId")
    private String fromClientId;


    @ApiModelProperty(value = "音视频类型: 1-video或2-voice")
    private Integer callType;


    @ApiModelProperty("频道状态，1：音视频发起，2：音视频中，3：音视频结束, 4:没有记录")
    private Integer state;
}
