package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 会话表 Mapper 接口
 *
 * @author wei
 * @since 2021-05-07
 */
@Repository
public interface ImConversationMapper extends BaseMapper<ImConversation> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImConversationQueryVo getImConversationById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imConversationPageParam
     * @return
     */
    IPage<ImConversationQueryVo> getImConversationPageList(@Param("page") Page page, @Param("param") ImConversationPageParam imConversationPageParam);

}
