package com.wecloud.im.controller;

import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.service.ImConversationService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会话表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/imConversation")
@Api(value = "会话表API", tags = {"会话表"})
public class ImConversationController extends BaseController {

    @Autowired
    private ImConversationService imConversationService;

    /**
     * 添加会话表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加会话表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加会话表")
    public ApiResult<Boolean> addImConversation(@Validated(Add.class) @RequestBody ImConversation imConversation) throws Exception {
        boolean flag = imConversationService.saveImConversation(imConversation);
        return ApiResult.result(flag);
    }

    /**
     * 修改会话表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改会话表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改会话表")
    public ApiResult<Boolean> updateImConversation(@Validated(Update.class) @RequestBody ImConversation imConversation) throws Exception {
        boolean flag = imConversationService.updateImConversation(imConversation);
        return ApiResult.result(flag);
    }

    /**
     * 删除会话表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除会话表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除会话表")
    public ApiResult<Boolean> deleteImConversation(@PathVariable("id") Long id) throws Exception {
        boolean flag = imConversationService.deleteImConversation(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取会话表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "会话表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "会话表详情")
    public ApiResult<ImConversationQueryVo> getImConversation(@PathVariable("id") Long id) throws Exception {
        ImConversationQueryVo imConversationQueryVo = imConversationService.getImConversationById(id);
        return ApiResult.ok(imConversationQueryVo);
    }

    /**
     * 会话表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "会话表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "会话表分页列表")
    public ApiResult<Paging<ImConversationQueryVo>> getImConversationPageList(@Validated @RequestBody ImConversationPageParam imConversationPageParam) throws Exception {
        Paging<ImConversationQueryVo> paging = imConversationService.getImConversationPageList(imConversationPageParam);
        return ApiResult.ok(paging);
    }

}

