package com.wecloud.netty.dispatch;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

import com.wecloud.im.core.util.JsonUtils;
import com.wecloud.im.server.model.WsResponse;
import com.wecloud.im.server.model.request.PushVO;
import com.wecloud.netty.dispatch.annotation.ActionMapping;
import com.wecloud.netty.dispatch.extend.ActionRequest;

/**
 * 这是一个示例，前端websocket的写法：

 {
 "reqId":"123123123",
 "action":"/sendtest/gogo",
 "hello":"我的测试",
 "push": {
 "title": "标题",
 "subTitle": "子标题"
 },
 "pList": [
 {
 "title": "p1标题",
 "subTitle": "p1子标题"
 },{
 "title": "p2标题",
 "subTitle": "p2子标题"
 }],
 "pSet": [
 {
 "title": "p3标题",
 "subTitle": "p3子标题"
 },{
 "title": "p4标题",
 "subTitle": "p4子标题"
 }],
 "pMap": {
 "testKey1": "testValue1",
 "testKey2": "testValue2"
 }
 }
 * @author lixiaozhong
 */
@Controller
@ActionMapping(value = "/sendtest")
@Api(value = "测试方法类", tags = {"websocket报文-全部采用json传输"})
@Slf4j
public class WsTestAction {

    /**
     * test
     * @param reqId
     * @param nihao
     * @param push
     * @param pList
     * @param pSet
     * @param pMap
     */
    @ActionMapping(value = "gogo")
    @ApiOperation(value = "测试方法")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "reqId", value = "请求id", required = false),
            @ApiImplicitParam(name = "hello", value = "测试参数hello", required = true),
            @ApiImplicitParam(name = "push", value = "push", dataTypeClass = PushVO.class),
            @ApiImplicitParam(name = "pList", value = "请求pList", dataTypeClass = List.class),
            @ApiImplicitParam(name = "pSet", value = "参数pSet", dataTypeClass = Set.class),
            @ApiImplicitParam(name = "pMap", value = "参数pMap", dataTypeClass = Map.class),
            @ApiImplicitParam(name = "request", value = "请求上下文，内部生成，不用传参", required = false),
    })
    public WsResponse<Boolean> testMyDispatch(String reqId,
                                              @RequestParam("hello") String nihao,
                                              @RequestParam("push") PushVO push,
                                              ArrayList<PushVO> pList,
                                              Set<PushVO> pSet,
                                              Map<String, String> pMap,
                                              @RequestParam("request") ActionRequest request) {
        log.info(reqId);
        log.info(nihao);
        log.info(JsonUtils.encodeJson(push));
        log.info(JsonUtils.encodeJson(pList));
        log.info(JsonUtils.encodeJson(pSet));
        log.info(JsonUtils.encodeJson(pMap));
        log.info(request.getSenderClientId() + "");
        WsResponse<Boolean> wsResponse = new WsResponse<>();
        wsResponse.setCmd(0).setData(true).setCode(0).setMsg("msg").setReqId(reqId);
        return wsResponse;
    }
}
