package com.wecloud.im.server.router;

import lombok.extern.slf4j.Slf4j;

import java.util.List;

import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wecloud.im.core.util.IpUtil;
import com.wecloud.im.server.sender.ChannelSender;

@Slf4j
@Service
@DubboService
public class RouterSendServiceImpl implements RouterSendService {

    @Autowired
    private ChannelSender channelSender;

    @Override
    public void sendMsgRemote(Long clientId, Integer platform, String msg) {
        log.info("接收到rpc调用，本地ip {}", IpUtil.getLocalhostIp());
        channelSender.sendMsgLocal(clientId, platform, msg);
    }

    @Override
    public void batchSendMsgRemote(List<String> sendRouterKeys, String msg) {
        channelSender.batchSendMsgLocal(sendRouterKeys, msg);
    }
}
