package com.wecloud.im.security.service;

import javax.servlet.http.HttpServletResponse;

import com.wecloud.im.security.jwt.JwtToken;
import com.wecloud.im.security.vo.JwtTokenRedisVo;

/**
 * @author geekidea
 * @date 2020/3/24
 **/
public interface ShiroLoginService {
    /**
     * 如果(当前时间+倒计时) > 过期时间，则刷新token
     * 并更新缓存
     * 当前token失效，返回新token
     * 当前请求有效，返回状态码：460
     * 前端下次使用新token
     * 如果token继续发往后台，则提示，此token已失效，请使用新token，不在返回新token，返回状态码：461
     *
     * @param jwtToken
     * @param httpServletResponse
     * @throws Exception
     */
    void refreshToken(JwtToken jwtToken, HttpServletResponse httpServletResponse) throws Exception;


    /**
     * 从redis获取token信息
     *
     * @param token
     * @return
     */
    JwtTokenRedisVo getTokenInfoForRedis(String token);


    /**
     * 从redis获取token信息
     */
    JwtToken getJwtTokenForRedis(String token);

    /**
     * 获取盐
     *
     * @param token
     * @return
     */
    String getSalt(String token);

}
