package com.wecloud.im.security.convert;

import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import com.wecloud.im.security.jwt.JwtToken;
import com.wecloud.im.security.vo.JwtTokenRedisVo;

/**
 * Shiro包下使用mapstruct对象属性复制转换器
 *
 * @author geekidea
 * @date 2019-09-30
 * @since 1.3.0.RELEASE
 **/
@Mapper
public interface ShiroMapstructConvert {

    ShiroMapstructConvert INSTANCE = Mappers.getMapper(ShiroMapstructConvert.class);

    /**
     * JwtToken对象转换成JwtTokenRedisVo
     *
     * @param jwtToken
     * @return
     */
    JwtTokenRedisVo jwtTokenToJwtTokenRedisVo(JwtToken jwtToken);

}
