package com.wecloud.im.core.config.jackson.serializer;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * <p>
 * Jackson Long反序列化器
 * </p>
 *
 * @author geekidea
 * @date 2018-11-08
 */
public class JacksonLongSerializer extends JsonSerializer<Long> {

    @Override
    public void serialize(Long aLong, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String string = null;
        if (aLong != null) {
            string = aLong.toString();
        }
        jsonGenerator.writeString(string);
    }
}
