package com.wecloud.im.core.config.jackson.deserializer;

import java.io.IOException;
import java.util.Date;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.wecloud.im.core.config.converter.StringToDateUtil;

/**
 * <p>
 * Jackson Date序列化器
 * </p>
 *
 * @author geekidea
 * @date 2018-11-08
 */
public class JacksonDateDeserializer extends JsonDeserializer<Date> {
    @Override
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String date = jp.getText();
        return StringToDateUtil.convert(date);
    }

}
