package com.wecloud.im.biz.module.message.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.wecloud.im.biz.module.message.entity.ImApplication;
import com.wecloud.im.biz.module.message.entity.ImClient;
import com.wecloud.im.biz.module.message.service.ContextService;
import com.wecloud.im.biz.module.message.service.ImApplicationService;
import com.wecloud.im.biz.module.message.service.ImClientService;
import com.wecloud.im.core.common.exception.BusinessException;

/**
 * 请求上下文服务 impl
 * @Author luozh
 * @Date 2022年04月02日 14:56
 * @Version 1.0
 */
@Service
public class ContextServiceImpl implements ContextService {


    @Autowired
    @Lazy
    private ImClientService imClientService;

    @Autowired
    private ImApplicationService imApplicationService;

    @Override
    public ImClient getImClientIfNotNullOrThrow() {

        ImClient currentClient = imClientService.getCurrentClient();

        if (currentClient == null) {
            throw new BusinessException("当前用户登录信息失效");
        }
        return currentClient;
    }

    @Override
    public ImApplication getImApplicationIfNotNullOrThrow(Long appId) {
        ImApplication imApplication = imApplicationService.getCacheById(appId);
        if (imApplication == null) {
            throw new BusinessException("查无应用信息");
        }
        return imApplication;
    }
}
