package com.wecloud.im.biz.module.message.service;

import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistQueryVo;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.biz.module.message.entity.ImClientBlacklist;
import com.wecloud.im.core.common.service.BaseService;
import com.wecloud.im.core.pagination.Paging;

/**
 * 黑名单 服务类
 *
 * @author wei
 * @since 2021-06-17
 */
public interface ImClientBlacklistService extends BaseService<ImClientBlacklist> {


    /**
     * 当前客户端是否被拉黑
     *
     * @param currentClientId 当前客户端
     * @param toClientId      对方客户端
     * @return
     */
    boolean isBeBlack(String currentClientId, String toClientId);

    /**
     * 拉入黑名单
     *
     * @param imClientBlacklistUpdate
     * @return
     * @throws Exception
     */
    Boolean addImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate);

    /**
     * 移出黑名单
     *
     * @param imClientBlacklistUpdate
     * @return
     * @throws Exception
     */
    Boolean removeImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate);

    /**
     * 获取分页对象
     *
     * @return
     * @throws Exception
     */
    Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageList(ImClientBlacklistPageParam imClientBlacklistPageParam);

    /**
     * 获取分页对象
     *
     * @return
     * @throws Exception
     */
    Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageListSdk(ImClientBlacklistPageParam imClientBlacklistPageParam);

}
