package com.wecloud.im.biz.module.message.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.biz.module.message.entity.ImFriendRecommend;
import com.wecloud.im.biz.module.message.param.ImFriendRecommendDto;

/**
 * @Description 好友推荐关系mapper
 * @Author lixiaozhong
 * @Date 2022/1/12 11:41 上午
 */
@Repository
public interface ImFriendRecommendMapper extends BaseMapper<ImFriendRecommend> {

    IPage<ImFriendRecommendDto> getImFriendRecommendPageList(@Param("page") Page pageParam, @Param("clientId") Long clientId);

    /**
     * 批量删除好友推荐
     * @param clientId
     * @param fkAppId
     * @param friendClientIds
     */
    void batchDeleteRecommend(@Param("clientId") String clientId, @Param("fkAppId") Long fkAppId, @Param("friendClientIds") List<String> friendClientIds);

    void batchCreateRecommend(@Param("list") List<ImFriendRecommend> list);
}
