package com.wecloud.im.biz.module.message.controller.param.add;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

import com.wecloud.im.biz.enums.JoinConversationTypeEnum;
import com.wecloud.im.core.common.entity.BaseEntity;

/**
 * @author wei
 * @since 2021年11月30日16:57:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImClientToConversation")
public class ImClientToConversation extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会话表id")
    private Long conversationId;

    @ApiModelProperty("要操作的clientId")
    private List<String> clientIds;

    @ApiModelProperty("加入方式 ")
    private JoinConversationTypeEnum joinConversationType;

    @ApiModelProperty("邀请人clientId")
    private String inviterClientId;

}
