package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import com.wecloud.im.core.common.entity.BaseEntity;

/**
 * @Author wenzhida
 * @Date 2022/4/27 11:44
 * @Description 用户退出聊天室入参
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "用户退出聊天室入参")
public class ExitChatRoomParam extends BaseEntity {

    private static final long serialVersionUID = -3602523207000275557L;

    @ApiModelProperty("聊天室id")
    private Long chatRoomId;

    @ApiModelProperty("离开聊天室的clientId")
    private String clientId;

    @ApiModelProperty("客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs, 需与生成sign时的值一致")
    private Integer platform;

}
