package com.wecloud.im.biz.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import com.wecloud.im.core.common.enums.BaseEnum;

/**
 * 审核状态,0审核中,1审核通过,2审核未通过
 **/
@Getter
@AllArgsConstructor
public enum StateAuditStatusEnum implements BaseEnum {


    /**
     * 0审核中
     **/
    UNDER_REVIEW(0, "0审核中"),
    /**
     * 1审核通过
     **/
    PASSED(1, "1审核通过"),
    /**
     * 2审核未通过
     **/
    FAILED_THE_AUDIT(2, "2审核未通过");

    private final Integer code;
    private final String desc;

}
