package com.wecloud.im.biz.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientBlacklistQueryVo;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.biz.module.message.service.ImClientBlacklistService;
import com.wecloud.im.core.log.annotation.OperationLog;
import com.wecloud.im.core.log.enums.OperationLogType;
import com.wecloud.im.core.pagination.Paging;
import com.wecloud.im.server.model.WsResponse;
import com.wecloud.netty.dispatch.annotation.ActionMapping;

/**
 * ws 黑名单
 * @Author luozh
 * @Date 2022年04月02日 09:20
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/blacklist")
@Api(value = "ws-黑名单API", tags = {"ws-黑名单"})
public class BlacklistAction {

    @Autowired
    private ImClientBlacklistService imClientBlacklistService;

    /**
     * 添加黑名单
     */
    @ActionMapping("/add")
    @ApiOperation(value = "拉入黑名单")
    public WsResponse<Map<String, Boolean>> addImClientBlacklist(ImClientBlacklistUpdate data) {
        imClientBlacklistService.addImClientBlacklist(data);
        return WsResponse.ok();
    }


    /**
     * 删除黑名单
     */
    @ActionMapping("/delete")
    @ApiOperation(value = "移出黑名单")
    public WsResponse<Map<String, Boolean>> deleteImClientBlacklist(ImClientBlacklistUpdate data) {
        imClientBlacklistService.removeImClientBlacklist(data);
        return WsResponse.ok();
    }

    /**
     * 黑名单分页列表
     * @return
     */
    @ActionMapping("/getPageList")
    @OperationLog(name = "黑名单分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "黑名单分页列表")
    public WsResponse<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(ImClientBlacklistPageParam data) {
        Paging<ImClientBlacklistQueryVo> blacklist =
                imClientBlacklistService.getImClientBlacklistPageList(data);
        return WsResponse.ok(blacklist);
    }
}
