package com.wecloud.im.ws.model;

import lombok.extern.slf4j.Slf4j;

/**
 * ws相关的常量
 */
@Slf4j
public class WsConstants {

    /**
     * Nacos公网ip
     */
    public static final String IP_NETTY_PUBLIC = "ip.netty.public";

    /*
     * 当前服务器cpu核心数量（）
     */
    public static final Integer CPU_PROCESSORS = Runtime.getRuntime().availableProcessors();

    static {
        log.info("CPU_PROCESSORS:" + CPU_PROCESSORS);
    }

    /**
     * 长连接url
     */
    public static final String WS_URL = "/ws";

    /**
     * token
     */
    public static final String TOKEN = "token";

}
