package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 会话成员表
 *
 * @author wei
 * @since 2021-05-07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImConversationMembers对象")
public class ImConversationMembers extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "唯一id不能为空")
    @ApiModelProperty("唯一id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("加入时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @NotNull(message = "会话表id不能为空")
    @ApiModelProperty("会话表id")
    private Long fkConversationId;

    @NotNull(message = "客户端id不能为空")
    @ApiModelProperty("客户端id")
    private Long fkClientId;

    @ApiModelProperty("可选	自定义属性，供开发者扩展使用。")
    private String attributes;

    @NotNull(message = "单向删除(隐藏)会话, 0不显示, 1显示不能为空")
    @ApiModelProperty("单向删除(隐藏)会话, 0不显示, 1显示")
    private Long displayStatus;
}
