package io.geekidea.springbootplus.scheduled;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.service.ImMessageService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @Author Future
 * @Date 2022/9/27 14:29
 * @Description 离线消息
 */
@Slf4j
@Component
public class MessageScheduled {

    @Autowired
    private ImInboxService imInboxService;

    @Autowired
    private ImMessageService imMessageService;

    /**
     * 离线消息处理定时器
     * 7之前的离线消息直接删除
     * 一天执行一次 凌晨3点执行
     */
    @Scheduled(cron = "0 0 3 * * ?")
    public void inboxDelete() {
        log.info("离线消息处理定时器处理开始...");
        // 7天之前数据， 直接删除
        Date allDeleteTime = DateUtils.addDays(new Date(), -7);
        imInboxService.remove(new QueryWrapper<ImInbox>().lambda()
                .lt(ImInbox::getCreateTime, allDeleteTime));
    }

    /**
     * 离线消息处理定时器
     * 一个月之前消息直接删除
     * 一天执行一次 凌晨1点执行
     */
    @Scheduled(cron = "0 0 1 * * ?")
    public void messageDelete() {
        log.info("离线消息处理定时器处理开始...");
        // 30天之前数据， 直接删除
        Date allDeleteTime = DateUtils.addDays(new Date(), -30);
        imMessageService.remove(new QueryWrapper<ImMessage>().lambda()
                .lt(ImMessage::getCreateTime, allDeleteTime));
    }

}
