package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.mapper.ImInboxMapper;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.vo.ConversationCountVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 消息收件箱表 服务实现类
 *
 * @author wei
 * @since 2021-05-06
 */
@Slf4j
@Service
public class ImInboxServiceImpl extends BaseServiceImpl<ImInboxMapper, ImInbox> implements ImInboxService {

    @Autowired
    private ImInboxMapper imInboxMapper;

    @Autowired
    private ImClientService imClientService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateImMsgReceived(ImMsgReceivedStatusUpdate imMsgReceivedUpdate) {
        ImClient currentClient = imClientService.getCurrentClient();
        // 修改已接收状态
        imInboxMapper.updateImMsgReceivedByIds(currentClient.getId(), imMsgReceivedUpdate.getMsgIds());
        // 是否同时修改为已读状态
        if (imMsgReceivedUpdate.getReadStatus()) {
            MsgReadStatusUpdateParam msgReadStatusUpdateParam = new MsgReadStatusUpdateParam();
            msgReadStatusUpdateParam.setMsgIds(imMsgReceivedUpdate.getMsgIds());
            this.updateImMsgRead(msgReadStatusUpdateParam);
        }
        return true;
    }

    /**
     * 统计未读消息数量
     *
     * @param fkClientId
     * @return
     */
    @Override
    public List<ConversationCountVo> countNotRead(Long fkClientId) {
        return imInboxMapper.countMyNotRead(fkClientId);
    }

    @Override
    public List<ConversationCountVo> countBeAt(ImClient imClient) {
        return imInboxMapper.countBeAt(imClient.getId(), imClient.getClientId());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateImMsgRead(MsgReadStatusUpdateParam param) {
        ImClient currentClient = imClientService.getCurrentClient();
        // 修改已读状态
        LambdaQueryWrapper<ImInbox> wrapper = new QueryWrapper<ImInbox>().lambda()
                .eq(param.getConversationId()!= null,ImInbox::getFkConversationId, param.getConversationId())
                .eq(ImInbox::getReceiver, currentClient.getId());
        if (CollectionUtils.isEmpty(param.getMsgIds())) {
            return true;
        }
        wrapper.in(ImInbox::getFkMsgId, param.getMsgIds());
        this.remove(wrapper);
        return true;

    }

    @Override
    public Boolean updateMsgReadStatusByConversation(UpdateMsgReadStatusByConversationParam param) {
        ImClient currentClient = imClientService.getCurrentClient();
        LambdaQueryWrapper<ImInbox> wrapper = new QueryWrapper<ImInbox>().lambda()
                .eq(ImInbox::getFkConversationId, param.getConversationId())
                .eq(ImInbox::getReceiver, currentClient.getId());
        if (param.getMsgIdEnd() != null) {
            wrapper.le(ImInbox::getFkMsgId, param.getMsgIdEnd());
        }
        this.remove(wrapper);
        return true;
    }


}
