package com.wecloud.im.action;

import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.service.ImInboxService;

/**
 *
 * @Author luozh
 * @Date 2022年04月02日 16:39
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/inbox")
@Api(value = "ws-消息收件箱API", tags = {"消息收件箱"})
public class InboxAction {

    @Autowired
    private ImInboxService imInboxService;

    /**
     * 消息修改为已接收状态
     */
    @PostMapping("/msgReceivedUpdate")
    @ApiOperation(value = "消息修改为已接收状态")
    public ApiResult<Boolean> updateImMsgReceived(@RequestBody @Validated ImMsgReceivedStatusUpdate imMsgReceivedUpdate) throws Exception {
        return imInboxService.updateImMsgReceived(imMsgReceivedUpdate);
    }

    /**
     * 消息修改为已读状态
     */
    @PostMapping("/msgReadUpdate")
    @ApiOperation(value = "消息修改为已读状态")
    public ApiResult<Boolean> updateInMsgReadUpdate(@RequestBody MsgReadStatusUpdateParam msgReadStatusUpdateParam) throws Exception {
        if (CollectionUtils.isEmpty(msgReadStatusUpdateParam.getMsgIds())) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return imInboxService.updateImMsgRead(msgReadStatusUpdateParam);
    }

    /**
     * 会话消息修改为已读状态
     */
    @PostMapping("/updateMsgReadStatusByConversation")
    @ApiOperation(value = "会话消息修改为已读状态")
    public ApiResult<Boolean> updateMsgReadStatusByConversation(@RequestBody UpdateMsgReadStatusByConversationParam param) throws Exception {
        if (param.getConversationId() == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return ApiResult.ok(imInboxService.updateMsgReadStatusByConversation(param));
    }
}
