package com.wecloud.im.action;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ListConversationMembersParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.vo.ConversationMemberVo;

/**
 *
 * @Author luozh
 * @Date 2022年04月02日 16:41
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/conversationMembers")
@Api(value = "ws-会话成员API", tags = {"会话成员"})
public class ConversationMembersAction {
    @Autowired
    private ImConversationMembersService imConversationMembersService;

    /**
     * 添加或修改会话成员备注
     */
    @PostMapping("/updateClientRemarkName")
    @ApiOperation(value = "添加或修改会话成员备注", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateClientRemarkName(@RequestBody ImConvMemeClientRemarkNameParam imConvMemeClientRemarkNameParam) throws Exception {
        imConversationMembersService.saveOrUpdateClientRemarkName(imConvMemeClientRemarkNameParam);
        return ApiResult.ok();
    }


    /**
     * 添加或修改会话成员拓展字段
     */
    @PostMapping("/updateAttr")
    @ApiOperation(value = "添加或修改会话成员拓展字段", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateAttr(@RequestBody ImConversationMemAttrUpdate imConversationMemAttrUpdate) throws Exception {
        return imConversationMembersService.saveOrUpdateAttr(imConversationMemAttrUpdate);
    }


    /**
     * 会话中成员表列表
     */
    @PostMapping("/getList")
    @ApiOperation(value = "获取会话中成员表列表")
    public ApiResult<List<ConversationMemberVo>> getImConversationMembersList(@Validated @RequestBody ListConversationMembersParam listConversationMembersParam) throws Exception {
//        Paging<ImConversationMembersQueryVo> paging = imConversationMembersService.getImConversationMembersPageList(imConversationMembersPageParam);
//        return ApiResult.ok(paging);
        return ApiResult.ok(imConversationMembersService.getImConversationMembersList(listConversationMembersParam));
    }
}
