package com.wecloud.im.sdk.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.model.ImRtcRecord;
import com.wecloud.im.sdk.model.PageResult;
import com.wecloud.im.sdk.model.RtcRecordRequest;

import static com.wecloud.im.sdk.ResourcePathConstants.LIST_RTC_RECORDS_REQUEST;

/**
 * @author nanqianhao
 * @date 2022/5/23
 * @apiNote
 */
public class WecloudImRtcRecordOperation extends WecloudImOperation {

    public WecloudImRtcRecordOperation(URL apiDomain, String appKey, String appSecret) {
        super(apiDomain, appKey, appSecret);
    }

    // 查看通话记录列表
    public PageResult<ImRtcRecord> listRtcRecords(RtcRecordRequest rtcRecordRequest) {

        // 校验通过 构建参数
        Map<String, Object> param = new HashMap<>();
        param.put("pageNum",rtcRecordRequest.getPageNum()+"");
        param.put("pageSize",rtcRecordRequest.getPageSize()+"");
        if (rtcRecordRequest.getFromClientId() != null && !"".equals(rtcRecordRequest.getFromClientId())){
            param.put("fromClientId", rtcRecordRequest.getFromClientId());

        }
        if (rtcRecordRequest.getToClientId() != null && !"".equals(rtcRecordRequest.getToClientId())){
            param.put("toClientId", rtcRecordRequest.getToClientId());

        }
        if (rtcRecordRequest.getChannelId() != null){
            param.put("channelId",rtcRecordRequest.getChannelId());
        }
        if (rtcRecordRequest.getCallType()!=null){
            param.put("callType",rtcRecordRequest.getCallType()+"");
        }

        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(LIST_RTC_RECORDS_REQUEST)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(rtcRecordRequest).build();

        Object result = doOperation(request);
        TypeReference<PageResult<ImRtcRecord>> typeReference = new TypeReference<PageResult<ImRtcRecord>>() {
        };
        PageResult<ImRtcRecord> rtcRecords = JSON.parseObject(JSON.toJSONString(result), typeReference);
        return rtcRecords;
    }
}
