package com.wecloud.rtc.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * Rtc应用产品配置表
 * </p>
 *
 * @author nanqianhao
 * @since 2022-06-09
 */
@Data
@ApiModel(value = "ApplicationProductsRtcConfig对象")
@TableName("application_products_rtc_config")
public class ApplicationProductsRtcConfig implements Serializable {

    private static final long serialVersionUID = -7343037669675536295L;

    /**
     * 主键id
     */
    @ApiModelProperty("rtc应用产品配置主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    /**
     * 应用id
     */
    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用id")
    private Long fkAppid;

    /**
     * 语音通话时长/分钟
     */
    @ApiModelProperty("语音通话时长/分钟")
    private Long voiceCallTimeRemain;

    /**
     * 视频通话HD时长/分钟
     */
    @ApiModelProperty("视频通话HD时长/分钟")
    private Long videoCallTimeRemain;

    /**
     * 音频录制时长/分钟
     */
    @ApiModelProperty("音频录制时长/分钟")
    private Long voiceRecordingTimeRemain;

    /**
     * 视频录制HD时长/分钟
     */
    @ApiModelProperty("视频录制HD时长/分钟")
    private Long videoRecordingTimeRemain;

    /**
     * 到期时间
     */
    @ApiModelProperty("到期时间")
    private LocalDateTime expireTime;

    /**
     * 创建人id
     */
    @ApiModelProperty("创建人id")
    private Long createBy;

    /**
     * 更新人id
     */
    @ApiModelProperty("更新人id")
    private Long updateBy;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;

    /**
     * 是否删除 0否 1是
     */
    @ApiModelProperty("是否删除 0否 1是")
    private Boolean isDeleted;

}
