package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 即时通讯应用产品配置表
 * </p>
 *
 * @author nanqianhao
 * @since 2022-06-09
 */
@Data
@TableName("application_products_im_config")
@ApiModel(value = "ApplicationProductsImConfig对象")
public class ApplicationProductsImConfig implements Serializable {

    private static final long serialVersionUID = 944045723943454871L;

    /**
     * 主键id
     */
    @ApiModelProperty("即时通讯应用产品配置主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    /**
     * 应用id
     */
    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用id")
    private Long fkAppid;

    /**
     * 群成员数量上限
     */
    @ApiModelProperty("群成员数量上限")
    private Integer groupMemberLimit;

    /**
     * 群组数量上限
     */
    @ApiModelProperty("群组数量上限")
    private Long groupNumberLimit;

    /**
     * 用户注册数上限
     */
    @ApiModelProperty("用户注册数上限")
    private Long userRegisterLimit;

    /**
     * 消息存储时长/天
     */
    @ApiModelProperty("消息存储时长/天")
    private Integer messageKeepDays;

    /**
     * 到期时间
     */
    @ApiModelProperty("到期时间")
    private LocalDateTime expireTime;

    /**
     * 月峰值日活用户
     */
    @ApiModelProperty("月峰值日活用户")
    private Long monthLiveUserMax;

    /**
     * 创建人id
     */
    @ApiModelProperty("创建人id")
    private Long createBy;

    /**
     * 更新人id
     */
    @ApiModelProperty("更新人id")
    private Long updateBy;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;

    /**
     * 是否删除 0否 1是
     */
    @ApiModelProperty("是否删除 0否 1是")
    private Boolean isDeleted;

}
