package com.wecloud.im.appmanager;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wecloud.im.entity.ImStatistics;
import com.wecloud.im.mapper.ImStatisticsMapper;
import com.wecloud.im.service.ImStatisticsService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class ImStatisticsImpl extends BaseServiceImpl<ImStatisticsMapper, ImStatistics> implements ImStatisticsService {
    @Override
    public List<ImStatistics> activeUserOrGroup(Long appId,Integer type, LocalDateTime start, LocalDateTime end) {

        return this.list(new LambdaQueryWrapper<ImStatistics>()
                .eq(ImStatistics::getFkAppid,appId)
                .eq(ImStatistics::getType,type)
                .ge(start!=null,ImStatistics::getTime,start)
                .le(end!=null,ImStatistics::getTime,end)
                .orderByAsc(ImStatistics::getTime)
        );
    }

}
