package com.wecloud.im.sdk.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Author Future
 * @Date 2022/6/3 13:12
 * @Description 单人音视频操作类型枚举
 */
public enum SingleRtcOperateTypeEnum implements BaseEnum {

    /**
     * 1 - 同意进入频道
     */
    JOIN(1, "join"),

    /**
     * 2 - 拒接进入频道
     */
    REJECT(2, "reject"),

    /**
     * 2 - 离开频道
     */
    LEAVE(3, "leave"),

    /**
     * 4 - 异常原因断开
     */
    ABNORMAL_DISCONNECT(4, "abnormalDisconnect");

    SingleRtcOperateTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
