package com.wecloud.im.sdk;

import java.util.List;

import com.wecloud.im.sdk.model.ChatRoomMember;
import com.wecloud.im.sdk.model.Conversation;
import com.wecloud.im.sdk.model.Friend;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.Token;
import com.wecloud.im.sdk.model.UnsureFriend;

/**
 *
 * @Author luozh
 * @Date 2022年04月13日 11:09
 * @Version 1.0
 */
public interface WecloudIm {

    /**
     * 注册客户端
     * @Author luozh
     * @Date 2022年04月13日 04:25:52
     * @param userId
     * @param headPortrait
     * @param nickname
     * @param deviceType
     * @Return
     * @return
     */
    ImClient registerClient(String userId, String headPortrait, String nickname);

    /**
     * 获取用户token
     * @Author luozh
     * @Date 2022年04月18日 11:50:44
     * @param userId 用户id
     * @param deviceType 设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac
     * @Return
     */
    Token getToken(String userId, Integer deviceType);


    /**
     * 修改用户
     * @Author luozh
     * @Date 2022年04月18日 03:29:52
     * @param userId 用户id
     * @param nickname 昵称
     * @param headPortrait 头像
     * @Return
     */
    Boolean modifyUser(String userId, String nickname, String headPortrait);

    /**
     * 获取好友请求列表
     * @Author luozh
     * @Date 2022年04月21日 04:50:57
     * @param userId 用户id
     * @Return
     */
    List<UnsureFriend> getUnsureFriends(String userId);

    /**
     * 获取所有好友列表
     * @Author luozh
     * @Date 2022年04月22日 11:45:15
     * @param userId 用户id
     * @Return
     */
    List<Friend> getFriends(String userId);

    /**
     * 设置会话置顶
     * @Author luozh
     * @Date 2022年04月26日 03:33:44
     * @param userId 用户id
     * @param conversationId 会话id
     * @param top 是否置
     * @Return
     */
    Boolean setConversationTop(String userId, Long conversationId, Boolean top);

    /**
     * 设置会话免打扰
     * @Author luozh
     * @Date 2022年04月26日 03:33:44
     * @param userId 用户id
     * @param conversationId 会话id
     * @param doNotDisturb 是否免打扰
     * @Return
     */
    Boolean setConversationDoNotDisturb(String userId, Long conversationId, Boolean doNotDisturb);

    /**
     * 好友申请
     * @Author luozh
     * @Date 2022年04月28日 02:05:11
     * @param userId 用户id
     * @param friendId 好友id
     * @param friendName 备注好友名称
     * @param requestRemark 请求备注
     * @Return
     */
    Boolean friendRequest(String userId, String friendId, String friendName, String requestRemark);

    /**
     * 群成员好友申请
     * @Author luozh
     * @Date 2022年04月28日 02:06:01
     * @param
     * @Return
     */
    Boolean groupMembersFriendRequest(Long conversationId, String userId, String friendId, String friendName,
                                      String requestRemark);

    /**
     * 全量获取聊天室成员
     * @param chatRoomId 聊天室id
     * @return
     */
    List<ChatRoomMember> listChatRoomMember(Long chatRoomId);

    /**
     * 批量获取会话信息
     * @param chatType 会话属性，1：单聊，2：普通群，3：万人群，4：聊天室
     * @param conversationIds
     * @return
     */
    List<Conversation> listConversation(Integer chatType, List<Long> conversationIds);

}
