package com.wecloud.im.controller;

import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.common.exception.BusinessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.wecloud.im.friend.param.ImFriendApplyParam;
import com.wecloud.im.param.ChatSettingParam;
import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ListConversationMembersParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.vo.ConversationMemberVo;

/**
 * 会话成员表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/imConversationMembers")
@Api(value = "会话成员表API", tags = {"会话成员表"})
public class ImConversationMembersController extends BaseController {

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    /**
     * 添加或修改会话成员备注
     */
    @PostMapping("/updateClientRemarkName")
    @ApiOperation(value = "添加或修改会话成员备注", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateClientRemarkName(@RequestBody ImConvMemeClientRemarkNameParam imConvMemeClientRemarkNameParam) throws Exception {
        imConversationMembersService.saveOrUpdateClientRemarkName(imConvMemeClientRemarkNameParam);
        return ApiResult.ok();
    }


    /**
     * 添加或修改会话成员拓展字段
     */
    @PostMapping("/updateAttr")
    @ApiOperation(value = "添加或修改会话成员拓展字段", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateAttr(@RequestBody ImConversationMemAttrUpdate imConversationMemAttrUpdate) throws Exception {
        boolean r = imConversationMembersService.saveOrUpdateAttr(imConversationMemAttrUpdate);
        if (r) {
            return ApiResult.ok();
        } else {
            return ApiResult.fail();
        }
    }


    /**
     * 会话中成员表列表
     */
    @PostMapping("/getList")
    @ApiOperation(value = "获取会话中成员表列表")
    public ApiResult<List<ConversationMemberVo>> getImConversationMembersList(@Validated @RequestBody ListConversationMembersParam listConversationMembersParam) throws Exception {
//        Paging<ImConversationMembersQueryVo> paging = imConversationMembersService.getImConversationMembersPageList(imConversationMembersPageParam);
//        return ApiResult.ok(paging);
        return ApiResult.ok(imConversationMembersService.getImConversationMembersList(listConversationMembersParam));
    }

    /**
     * 聊天设置
     * @Author luozh
     * @Date 2022年04月26日 11:48:59
     * @param
     * @Return
     */
    @ApiOperation(value = "聊天设置")
    @PostMapping("/chatSetting")
    public ApiResult<Boolean> chatSetting(@RequestBody ChatSettingParam param) {
        return ApiResult.ok(imConversationMembersService.chatSetting(param));
    }


    /**
     * 群成员添加好友
     * @Author luozh
     * @Date 2022年04月28日 11:40:44
     * @param
     * @Return
     */
    @ApiOperation(value = "群成员添加好友")
    @PostMapping("/addUser")
    public ApiResult<Boolean> addUser(@RequestBody ImFriendApplyParam param) {
        if (param.getConversationId() == null) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION.getCode(), "参数: conversationId 不能为空");
        }
        if (StringUtils.isBlank(param.getFriendName())) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION.getCode(), "参数: friendName 不能为空");
        }
        if (StringUtils.isBlank(param.getClientId())) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION.getCode(), "参数: clientId 不能为空");
        }
        if (StringUtils.isBlank(param.getFriendClientId())) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION.getCode(), "参数: friendClientId 不能为空");
        }
        return ApiResult.ok(imConversationMembersService.addUser(param));
    }

}

