package com.wecloud.im.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.ws.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

import java.time.Duration;
import java.util.List;


/**
 * @Author Future
 * @Date 2022/8/24 17:18
 * @Description 本地缓存服务
 */
@Slf4j
@Service
public class EhcacheService {

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private ImConversationService imConversationService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    @Autowired
    private RedisUtils redisUtils;


    /**
     * 缓存中获取
     *
     * @param key
     * @return
     */
    public Boolean getIsPush(String key) {
        try {
            String value = redisUtils.getKey(key);
            if (StringUtils.isNotBlank(value)) {
                // 缓存中有数据 不做系统消息推送
                return false;
            } else {
                // 缓存中无数据， 设置缓存 3分钟， 并且需要推送
                redisUtils.addKey(key, "1", Duration.ofMinutes(3));
                return true;
            }
        } catch (Exception e) {
            log.info("取本地push缓存异常", e);
            return false;
        }
    }

//    @Cacheable(value = "business", key = "#id")
    public ImClient getEhCacheClient(Long id) {
        return imClientService.getCacheImClient(id);
    }

//    @Cacheable(value = "business", key = "#id")
    public ImConversationQueryVo getEhCacheConversation(Long id) {
        return imConversationService.getCacheImConversationById(id);
    }

//    @CacheEvict(value = "business", key = "#id")
    public void delEhCacheConversation(Long id) {
    }

//    @Cacheable(value = "business", key = "#key")
    public List<ImConversationMembers> getEhCacheMember(String key, Long id) {
        return imConversationMembersService.list(new QueryWrapper<ImConversationMembers>().lambda()
                        .eq(ImConversationMembers::getFkConversationId, id));
    }

//    @CacheEvict(value = "business", key = "#key")
    public void delEhCacheMember(String key) {
    }

}
