package com.wecloud.im.sdk.enums;

/**
 * @Author wenzhida
 * @Date 2022/4/27 10:28
 * @Description 添加好友来源枚举
 */
public enum FriendSourceEnum {

    /**
     * 1 - 搜索
     */
    SEARCH("SEARCH", "搜索"),

    /**
     * 2 - 群聊
     */
    GROUP("GROUP", "群聊"),

    /**
     * 3 - 名片
     */
    CARD("CARD", "名片");

    FriendSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final String code;
    private final String desc;

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}
