package com.jumeirah.common.service;

import com.jumeirah.common.entity.MerchantRolePermission;
import com.jumeirah.common.param.MerchantRolePermissionPageParam;
import com.jumeirah.common.vo.MerchantRolePermissionQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.Set;

/**
 * 商家角色权限关系 服务类
 *
 * @author wei
 * @since 2020-09-28
 */
public interface MerchantRolePermissionService extends BaseService<MerchantRolePermission> {

    /**
     * 保存
     *
     * @param merchantRolePermission
     * @return
     * @throws Exception
     */
    boolean saveMerchantRolePermission(MerchantRolePermission merchantRolePermission) throws Exception;

    /**
     * 修改
     *
     * @param merchantRolePermission
     * @return
     * @throws Exception
     */
    boolean updateMerchantRolePermission(MerchantRolePermission merchantRolePermission) throws Exception;



    /**
     * 根据角色id获取可用的权限编码
     *
     * @param roleId
     * @return
     * @throws Exception
     */
    Set<String> getPermissionCodesByRoleId(Long roleId) throws Exception;
    
    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteMerchantRolePermission(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    MerchantRolePermissionQueryVo getMerchantRolePermissionById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param merchantRolePermissionPageParam
     * @return
     * @throws Exception
     */
    Paging<MerchantRolePermissionQueryVo> getMerchantRolePermissionPageList(MerchantRolePermissionPageParam merchantRolePermissionPageParam) throws Exception;

}
