package com.wecloud.im.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.vo.ConversationCountVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;

import java.util.List;

/**
 * 消息收件箱表 服务类
 *
 * @author wei
 * @since 2021-05-06
 */
public interface ImInboxService extends BaseService<ImInbox> {

    /**
     * 消息修改为已接收状态
     *
     * @param imMsgReceivedUpdate
     * @return
     */
    Boolean updateImMsgReceived(ImMsgReceivedStatusUpdate imMsgReceivedUpdate);

    /**
     * 统计未读消息数量
     *
     * @param fkClientId
     * @return
     */
    List<ConversationCountVo> countNotRead(Long fkClientId);

    /**
     * 统计被@数量
     *
     * @param imClient
     * @return
     */
    List<ConversationCountVo> countBeAt(ImClient imClient);

    /**
     * 消息修改为已读状态
     *
     * @return
     */
    Boolean updateImMsgRead(MsgReadStatusUpdateParam msgReadStatusUpdateParam) throws JsonProcessingException;

    /**
     * 整个会话消息修改为已读状态
     * @param param
     * @return
     */
    Boolean updateMsgReadStatusByConversation(UpdateMsgReadStatusByConversationParam param);

}
