package com.wecloud.im.param;

import io.geekidea.springbootplus.framework.core.pagination.BasePageOrderParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <pre>
 * 消息存储表 分页参数对象
 * </pre>
 *
 * @author wei
 * @date 2021-04-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImHistoryMessagePageParam")
public class ImHistoryMessagePageParam extends BasePageOrderParam {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会话id")
    private Long conversationId;

    /**
     * 消息id最小值
     */
    @ApiModelProperty("消息id最小值")
    private Long msgIdStart;

    /**
     * 消息id最大值
     */
    @ApiModelProperty("消息id最大值")
    private Long msgIdEnd;

    /**
     * 当前操作人client主键id
     */
    private Long currentFkClientId;

    @ApiModelProperty("是否获取最后一条 0-否 1-是")
    private Integer getLast;
}
