package com.ym.im.entity;

import com.ym.im.entity.base.BaseSocketInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author: JJww
 * @Date:2019-05-21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class UserSocketInfo extends BaseSocketInfo {

    private String col;

    private Long userId;

    private Set<Long> sessionList;

    private DeviceTokenParam deviceTokenParam;

    private Map<Long, Long> staffIds = new HashMap<>();

    public Long getStaffId(Long merchantId) {
        return staffIds.get(merchantId);
    }

    public void setStaff(Long merchantId, Long staffId) {
        staffIds.put(merchantId, staffId);
    }


}
