package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.Merchant;
import com.jumeirah.common.mapper.MerchantMapper;
import com.jumeirah.common.param.MerchantPageParam;
import com.jumeirah.common.service.MerchantService;
import com.jumeirah.common.vo.MerchantQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 航空公司商家表 服务实现类
 *
 * @author giao
 * @since 2020-10-16
 */
@Slf4j
@Service
public class MerchantServiceImpl extends BaseServiceImpl<MerchantMapper, Merchant> implements MerchantService {

    @Autowired
    private MerchantMapper merchantMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveMerchant(Merchant merchant) throws Exception {
        return super.save(merchant);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateMerchant(Merchant merchant) throws Exception {
        return super.updateById(merchant);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteMerchant(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public MerchantQueryVo getMerchantById(Long id) throws Exception {
        return merchantMapper.getMerchantById(id);
    }

    @Override
    public Paging<MerchantQueryVo> getMerchantPageList(MerchantPageParam merchantPageParam) throws Exception {
        Page<MerchantQueryVo> page = new PageInfo<>(merchantPageParam, OrderItem.desc(getLambdaColumn(Merchant::getCreateTime)));
        IPage<MerchantQueryVo> iPage = merchantMapper.getMerchantPageList(page, merchantPageParam);
        return new Paging<MerchantQueryVo>(iPage);
    }

    @Override
    public List<Merchant> getMerchantList() {
        return baseMapper.selectList(new QueryWrapper<Merchant>().lambda()
                .eq(Merchant::getState, 1)
                .eq(Merchant::getDeleted, 0)
                .orderByDesc(Merchant::getCreateTime));
    }


}
