package com.wecloud.im.ws.enums;

/**
 * @Author wenzhida
 * @Date 2022/3/7 22:13
 * @Description 多人音视频响应类型
 */
public enum WsMultiMeetResponseSubCmdEnum {

    /**
     * 邀请
     */
    INVITE(1),

    /**
     * 拒接邀请
     */
    REJECT(2),

    /**
     * 同意进入
     */
    AGREE(3),

    /**
     * 主动离开
     */
    LEAVE(4),

    /**
     * 占线
     */
    BUSY(5);

    private final int cmdCode;

    WsMultiMeetResponseSubCmdEnum(int cmdCode) {
        this.cmdCode = cmdCode;
    }

    public int getCmdCode() {
        return cmdCode;
    }
}
